
const express = require('express');
const app = express();
const mysql = require('mysql');
const cors = require('cors');
const dbConfig = require('./db_config');
const categoriesRouter = require('./routes/categories');

// Configuração do banco de dados
const db = mysql.createConnection(dbConfig);
db.connect(err => {
  if (err) throw err;
  console.log('Conectado ao banco de dados');
});

// Middlewares
app.use(cors());
app.use(express.json());

// Rotas
app.use('/api/categories', categoriesRouter);

// Porta de execução
app.listen(3001, () => {
  console.log('Servidor rodando na porta 3001');
});
